package gov.va.med.mhv.ssoi;

import com.liferay.portal.UserLockoutException;

public class SystemDownException extends UserLockoutException {

	private static final long serialVersionUID = 6750776834057569336L;

	public enum ErrorCodeEnum {
		DEFAULT_ERROR(1000, "An error occured while making any API request."), ADMIN_SERVICE_RETRIEVAL_FAILURE_UPDATE(
				1001, "An error occurred performing post login updates against the User Management web service.");

		private Integer errorCode;
		private String message;

		ErrorCodeEnum(Integer errorCode, String message) {
			this.errorCode = errorCode;
			this.message = message;
		}

		public String getMessage() {
			return message;
		}

		public Integer getErrorCode() {
			return errorCode;
		}
	};

	private ErrorCodeEnum errorCode = ErrorCodeEnum.DEFAULT_ERROR;

	public SystemDownException() {
		super();
	}

	public SystemDownException(ErrorCodeEnum errorCode) {
		super();
		this.errorCode = errorCode;
	}

	public SystemDownException(String msg) {
		super(msg);
	}

	public SystemDownException(String msg, Throwable cause) {
		super(msg, cause);
	}

	public SystemDownException(Throwable cause) {
		super(cause);
	}

	public SystemDownException(ErrorCodeEnum errorCode, Throwable cause) {
		super(cause);
		this.errorCode = errorCode;
	}

	public Integer getErrorCode() {
		if (this.errorCode != null) {
			return this.errorCode.getErrorCode();
		}

		return -1;
	}

	@Override
	public String toString() {
		return String.format("MHVADMINAPI ERROR CODE: %d, MESSAGE: %s", this.errorCode.getErrorCode(),
				this.errorCode.getMessage());
	}
}
